/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.codechicken.lib.asm;

import cofh.repack.codechicken.lib.asm.ASMHelper;
import cofh.repack.codechicken.lib.config.ConfigTag;
import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.ForgeVersion;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ObfMapping {
    public static ObfRemapper obfMapper = new ObfRemapper();
    public static Remapper mcpMapper = null;
    public static final boolean obfuscated;
    public String s_owner;
    public String s_name;
    public String s_desc;

    public static void loadMCPRemapper() {
        if (mcpMapper == null) {
            mcpMapper = new MCPRemapper();
        }
    }

    public ObfMapping(String string) {
        this(string, "", "");
    }

    public ObfMapping(String string, String string2, String string3) {
        this.s_owner = string;
        this.s_name = string2;
        this.s_desc = string3;
        if (this.s_owner.contains(".")) {
            throw new IllegalArgumentException(this.s_owner);
        }
    }

    public ObfMapping(ObfMapping obfMapping, String string) {
        this(string, obfMapping.s_name, obfMapping.s_desc);
    }

    public static ObfMapping fromDesc(String string) {
        int n;
        int n2 = string.lastIndexOf(46);
        if (n2 < 0) {
            return new ObfMapping(string, "", "");
        }
        int n3 = n = string.indexOf(40);
        if (n < 0) {
            n = string.indexOf(32);
            n3 = n + 1;
        }
        if (n < 0) {
            n = string.indexOf(58);
            n3 = n + 1;
        }
        if (n < 0) {
            return new ObfMapping(string.substring(0, n2), string.substring(n2 + 1), "");
        }
        return new ObfMapping(string.substring(0, n2), string.substring(n2 + 1, n), string.substring(n3));
    }

    public ObfMapping subclass(String string) {
        return new ObfMapping(this, string);
    }

    public boolean matches(MethodNode methodNode) {
        return this.s_name.equals(methodNode.name) && this.s_desc.equals(methodNode.desc);
    }

    public boolean matches(MethodInsnNode methodInsnNode) {
        return this.s_owner.equals(methodInsnNode.owner) && this.s_name.equals(methodInsnNode.name) && this.s_desc.equals(methodInsnNode.desc);
    }

    public AbstractInsnNode toInsn(int n) {
        if (this.isClass()) {
            return new TypeInsnNode(n, this.s_owner);
        }
        if (this.isMethod()) {
            return new MethodInsnNode(n, this.s_owner, this.s_name, this.s_desc, false);
        }
        return new FieldInsnNode(n, this.s_owner, this.s_name, this.s_desc);
    }

    public void visitTypeInsn(MethodVisitor methodVisitor, int n) {
        methodVisitor.visitTypeInsn(n, this.s_owner);
    }

    public void visitMethodInsn(MethodVisitor methodVisitor, int n) {
        methodVisitor.visitMethodInsn(n, this.s_owner, this.s_name, this.s_desc, false);
    }

    public void visitFieldInsn(MethodVisitor methodVisitor, int n) {
        methodVisitor.visitFieldInsn(n, this.s_owner, this.s_name, this.s_desc);
    }

    public MethodVisitor visitMethod(ClassVisitor classVisitor, int n, String[] stringArray) {
        return classVisitor.visitMethod(n, this.s_name, this.s_desc, null, stringArray);
    }

    public FieldVisitor visitField(ClassVisitor classVisitor, int n, Object object) {
        return classVisitor.visitField(n, this.s_name, this.s_desc, null, object);
    }

    public boolean isClass(String string) {
        return string.replace('.', '/').equals(this.s_owner);
    }

    public boolean matches(String string, String string2) {
        return this.s_name.equals(string) && this.s_desc.equals(string2);
    }

    public boolean matches(FieldNode fieldNode) {
        return this.s_name.equals(fieldNode.name) && this.s_desc.equals(fieldNode.desc);
    }

    public boolean matches(FieldInsnNode fieldInsnNode) {
        return this.s_owner.equals(fieldInsnNode.owner) && this.s_name.equals(fieldInsnNode.name) && this.s_desc.equals(fieldInsnNode.desc);
    }

    public String javaClass() {
        return this.s_owner.replace('/', '.');
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObfMapping)) {
            return false;
        }
        ObfMapping obfMapping = (ObfMapping)object;
        return this.s_owner.equals(obfMapping.s_owner) && this.s_name.equals(obfMapping.s_name) && this.s_desc.equals(obfMapping.s_desc);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.s_desc, this.s_name, this.s_owner});
    }

    public String toString() {
        if (this.s_name.length() == 0) {
            return "[" + this.s_owner + "]";
        }
        if (this.s_desc.length() == 0) {
            return "[" + this.s_owner + "." + this.s_name + "]";
        }
        return "[" + (this.isMethod() ? this.methodDesc() : this.fieldDesc()) + "]";
    }

    public String methodDesc() {
        return this.s_owner + "." + this.s_name + this.s_desc;
    }

    public String fieldDesc() {
        return this.s_owner + "." + this.s_name + ":" + this.s_desc;
    }

    public boolean isClass() {
        return this.s_name.length() == 0;
    }

    public boolean isMethod() {
        return this.s_desc.contains("(");
    }

    public boolean isField() {
        return !this.isClass() && !this.isMethod();
    }

    public ObfMapping map(Remapper remapper) {
        if (remapper == null) {
            return this;
        }
        if (this.isMethod()) {
            this.s_name = remapper.mapMethodName(this.s_owner, this.s_name, this.s_desc);
        } else if (this.isField()) {
            this.s_name = remapper.mapFieldName(this.s_owner, this.s_name, this.s_desc);
        }
        this.s_owner = remapper.mapType(this.s_owner);
        if (this.isMethod()) {
            this.s_desc = remapper.mapMethodDesc(this.s_desc);
        } else if (this.s_desc.length() > 0) {
            this.s_desc = remapper.mapDesc(this.s_desc);
        }
        return this;
    }

    public ObfMapping toRuntime() {
        this.map(mcpMapper);
        return this;
    }

    public ObfMapping toClassloading() {
        if (!obfuscated) {
            this.map(mcpMapper);
        } else if (obfMapper.isObf(this.s_owner)) {
            this.map(obfMapper);
        }
        return this;
    }

    public ObfMapping copy() {
        return new ObfMapping(this.s_owner, this.s_name, this.s_desc);
    }

    static {
        boolean bl = true;
        try {
            bl = Launch.classLoader.getClassBytes("net.minecraft.world.World") == null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        obfuscated = bl;
        if (!bl) {
            ObfMapping.loadMCPRemapper();
        }
    }

    public static class MCPRemapper
    extends Remapper
    implements LineProcessor<Void> {
        private static final int DIR_GUESSES = 5;
        private static final int DIR_ASKS = 3;
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> funcs = new HashMap();

        public static File[] getConfFiles() {
            ConfigTag configTag = ASMHelper.config.getTag("mappingDir").setComment("Path to directory holding packaged.srg, fields.csv and methods.csv for mcp remapping");
            for (int i = 0; i < 8; ++i) {
                File[] fileArray;
                File file = MCPRemapper.confDirectoryGuess(i, configTag);
                if (file == null || file.isFile()) continue;
                try {
                    fileArray = MCPRemapper.parseConfDir(file);
                }
                catch (Exception exception) {
                    if (i < 5) continue;
                    exception.printStackTrace();
                    continue;
                }
                configTag.setValue(file.getPath());
                return fileArray;
            }
            throw new RuntimeException("Failed to select mappings directory, set it manually in the config");
        }

        public static File confDirectoryGuess(int n, ConfigTag configTag) {
            File file = (File)FMLInjectionData.data()[6];
            switch (n) {
                case 0: {
                    return configTag.value != null ? new File(configTag.getValue()) : null;
                }
                case 1: {
                    return new File(file, "../conf");
                }
                case 2: {
                    return new File(file, "../build/unpacked/conf");
                }
                case 3: {
                    return new File(System.getProperty("user.home"), ".gradle/caches/minecraft/net/minecraftforge/forge/" + FMLInjectionData.data()[4] + "-" + ForgeVersion.getVersion() + "/unpacked/conf");
                }
                case 4: {
                    return new File(System.getProperty("user.home"), ".gradle/caches/minecraft/net/minecraftforge/forge/" + FMLInjectionData.data()[4] + "-" + ForgeVersion.getVersion() + "-" + FMLInjectionData.data()[4] + "/unpacked/conf");
                }
            }
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Select an mcp conf dir for the deobfuscator.");
            int n2 = jFileChooser.showDialog(null, "Select");
            return n2 == 0 ? jFileChooser.getSelectedFile() : null;
        }

        public static File[] parseConfDir(File file) {
            File file2;
            File file3;
            File file4 = new File(file, "conf");
            if (!file4.exists()) {
                file4 = file;
            }
            if (!(file3 = new File(file4, "packaged.srg")).exists()) {
                file3 = new File(file4, "joined.srg");
            }
            if (!file3.exists()) {
                throw new RuntimeException("Could not find packaged.srg or joined.srg");
            }
            File file5 = new File(file, "mappings");
            if (!file5.exists()) {
                file5 = file;
            }
            if (!(file2 = new File(file5, "methods.csv")).exists()) {
                throw new RuntimeException("Could not find methods.csv");
            }
            File file6 = new File(file5, "fields.csv");
            if (!file6.exists()) {
                throw new RuntimeException("Could not find fields.csv");
            }
            return new File[]{file3, file2, file6};
        }

        public MCPRemapper() {
            File[] fileArray = MCPRemapper.getConfFiles();
            try {
                Resources.readLines((URL)fileArray[1].toURI().toURL(), (Charset)Charsets.UTF_8, (LineProcessor)this);
                Resources.readLines((URL)fileArray[2].toURI().toURL(), (Charset)Charsets.UTF_8, (LineProcessor)this);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public String mapMethodName(String string, String string2, String string3) {
            String string4 = this.funcs.get(string2);
            return string4 == null ? string2 : string4;
        }

        public String mapFieldName(String string, String string2, String string3) {
            String string4 = this.fields.get(string2);
            return string4 == null ? string2 : string4;
        }

        public boolean processLine(String string) throws IOException {
            int n = string.indexOf(44);
            String string2 = string.substring(0, n);
            int n2 = n + 1;
            n = string.indexOf(44, n2);
            String string3 = string.substring(n2, n);
            (string2.startsWith("func") ? this.funcs : this.fields).put(string2, string3);
            return true;
        }

        public Void getResult() {
            return null;
        }
    }

    public static class ObfRemapper
    extends Remapper {
        private HashMap<String, String> fields = new HashMap();
        private HashMap<String, String> funcs = new HashMap();

        public ObfRemapper() {
            try {
                Field field = FMLDeobfuscatingRemapper.class.getDeclaredField("rawFieldMaps");
                Field field2 = FMLDeobfuscatingRemapper.class.getDeclaredField("rawMethodMaps");
                field.setAccessible(true);
                field2.setAccessible(true);
                Map map = (Map)field.get(FMLDeobfuscatingRemapper.INSTANCE);
                Map map2 = (Map)field2.get(FMLDeobfuscatingRemapper.INSTANCE);
                if (map == null) {
                    throw new IllegalStateException("codechicken.lib.asm.ObfMapping loaded too early. Make sure all references are in or after the asm transformer load stage");
                }
                for (Map map3 : map.values()) {
                    for (Map.Entry entry : map3.entrySet()) {
                        if (!((String)entry.getValue()).startsWith("field")) continue;
                        this.fields.put((String)entry.getValue(), ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(58)));
                    }
                }
                for (Map map3 : map2.values()) {
                    for (Map.Entry entry : map3.entrySet()) {
                        if (!((String)entry.getValue()).startsWith("func")) continue;
                        this.funcs.put((String)entry.getValue(), ((String)entry.getKey()).substring(0, ((String)entry.getKey()).indexOf(40)));
                    }
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public String mapMethodName(String string, String string2, String string3) {
            String string4 = this.funcs.get(string2);
            return string4 == null ? string2 : string4;
        }

        public String mapFieldName(String string, String string2, String string3) {
            String string4 = this.fields.get(string2);
            return string4 == null ? string2 : string4;
        }

        public String map(String string) {
            return FMLDeobfuscatingRemapper.INSTANCE.unmap(string);
        }

        public String unmap(String string) {
            return FMLDeobfuscatingRemapper.INSTANCE.map(string);
        }

        public boolean isObf(String string) {
            return !this.map(string).equals(string) || !this.unmap(string).equals(string);
        }
    }
}

